local function FailedText(pn)
	local ret = AutoText("frutiger")..{
		Text="Failed";
		InitCommand=cmd(draworder,99;zoom,0.75;y,SCREEN_CENTER_Y-116;diffuse,color("#FF0000");shadowlength,1;NoStroke);
		BeginCommand=function(self)
			-- position x
			local p1xPos = SCREEN_CENTER_X*0.75;
			local p2xPos = SCREEN_CENTER_X*1.25;
			self:x( pn == PLAYER_1 and p1xPos or p2xPos );

			if STATSMAN:GetCurStageStats():AllFailed() and GAMESTATE:IsHumanPlayer(pn) then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	return ret;
end;

local under = Def.ActorFrame{
	LoadActor( THEME:GetPathB("ScreenEvaluation","common") );

	-- banner overlay
	Def.Quad{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-142;zoomto,256,80;draworder,98);
		OnCommand=function(self)
			-- todo: fix for two players with different fail status.
			local numPlayers = GAMESTATE:GetNumPlayersEnabled();
			local curStageStats = STATSMAN:GetCurStageStats();
			local allFailed = STATSMAN:GetCurStageStats():AllFailed();

			-- two players, one failed and one didn't.
			if numPlayers == 2 then
				-- see who failed
				local p1Stats = curStageStats:GetPlayerStageStats(PLAYER_1);
				local p2Stats = curStageStats:GetPlayerStageStats(PLAYER_2);

				if p1Stats:GetGrade() == 'Grade_Failed' then
					self:diffuseleftedge( color( "0,0,0,0.25" ) );
				end;

				if p2Stats:GetGrade() == 'Grade_Failed' then
					self:diffuserightedge( color( "0,0,0,0.25" ) );
				end;
			end;

			-- run general checks last
			if allFailed then
				self:diffuse( color( "0,0,0,0.25" ) );
				self:diffusebottomedge( color( "0,0,0,0.4" ) );
			else
				self:diffuse( color( "1,1,1,0" ) );
				self:diffusebottomedge( color( "1,1,1,0" ) );
			end;
		end;
	};

	FailedText(PLAYER_1);
	FailedText(PLAYER_2);
};

return under;